<?php

/* Datum      Beschreibung
11.05.2015    Anpassung fr ML4 in Konstruktor
              Anmeldenamen in iprntman nun full qualified LDAP
11.01.2012    Erstellungsdatum
*/

/*************************************************************************
**           iprintapi zur Druckersperre fr paedML Novell 4           **
*************************************************************************
**                Copyright Ulrich Frei                                **
*************************************************************************/
require_once("../_common/utils.inc.php");// allgemeine Routinen
require_once("../_common/novldap.php");

/*************************************************************************
*************************************************************************
**   Klasse iPrintApi                                                  **
*************************************************************************
*************************************************************************/
class iPrintApi
{

   // vordefinierte Werte
   public $VERSION = "11.05.2015/Fr.";// Version

   // Logging
   private $LOGFILE = "/var/lib/inet/logs/iPrint.log";// 11.01.2012
   private $MAX_LOGSIZE = 1000000;

   // Variablen
   private $iprintuser;
   private $pwd;
   private $ip;

   // Logfile und Debug
   private $now;
   private $fp_log;// Filepointer Logfile
   private $debug;
   private $LogBuf = array();


   // Konstruktor
   public function iPrintApi($ip, $iprintuser, $pwd, $debug)
   {
      // echo $iprinuser."<br>";
      if ($iprintuser!='') {
        if (stristr($iprintuser, '.') !== false)
        {
          // echo "mit punkt <br>";
          $iprintuser = str_replace('.',',ou=',$iprintuser);
          $p = strrpos($iprintuser,',');
          if ($p !== false) {
            $iprintuser = substr_replace($iprintuser,',o=',$p,4);
          }
          $this->iprintuser = 'cn='.$iprintuser;
          // $this->iprintuser = shortname($iprintuser);
        }
        else
        {
          //echo "ohne punkt <br>";
          $this->iprintuser = "cn=".$iprintuser.",ou=Server,ou=DIENSTE,o=ml3";
        }
      }
      
      
      // echo $this->iprintuser."<br>";


      $this->pwd = $pwd;
      $this->ip = $ip;
      $this->debug = $debug;

      $this->LogConnection();
   }// end iPrintApi

   // Destruktor
   public function Close()
   {
      $this->WriteToLog("iPrintApi closed - " . date("d.m.Y  H:i:s") . "<br>\n");
      $this->FlushLog($this->LOGFILE);
   }// end  Close

   /*************************************************************************
   **   Zugriff auf Parameter, Logging                                    **
   *************************************************************************/

   public function FlushLog($fnam)
   {
      if($this->debug) echo "Writing Logfile $fnam<br>\n";
      $logbak = explode(".", $fnam);
      $logres = $logbak['0'] . ".bak";

      if(file_exists($fnam))
      {
         $mode = 'a';
         if(filesize($fnam) > $this->MAX_LOGSIZE)
         {
            // Backup-File lschen
            if(file_exists($logres))
            {
               unlink($logres);
            }
            copy($fnam, $logres);
            $mode = 'w';
            unlink($fnam);
         }
      }
      else
      {
         $mode = 'w';
      }

      if(!$fp = fopen($fnam, $mode))
      {
         echo "Logdatei $fname kann nicht geffnet werden<br>\n";
      }
      else
      {
         flock($fp, 2);

         foreach($this->LogBuf  as $value)
         {
            fputs($fp, $value);
         }
         fputs($fp, "\n\n\n\n");

         flock($fp, 3);
         fclose($fp);
      }
   }// end CloseLog

   private function WriteToLog($line)
   {
      if($this->debug) echo str_replace(' ', '&nbsp;', $line);
      if($line == "<hr>") $line = str_pad("", 90, "-") . "\n";
      if($line == "<HR>") $line = str_pad("", 90, "-") . "\n";
      $this->LogBuf[] = strip_tags($line);
   }// WriteToLog

   public function setDebug($on)
   {
      $this->debug = $on;
   }// end setDebug

   private function ShowDefaults()
   {
      $this->WriteToLog("Voreinstellungen:<br>\n");
   }// showDefaults

   private function LogConnection()
   {
      $this->WriteToLog("<hr>");
      $this->WriteToLog("iPrintApi.php - Version " . $this->VERSION . "<br>\n");
      $this->WriteToLog("<hr>");
      $this->WriteToLog("Aufgerufen durch: " . $this->iprintuser . " von IP: " . $_SERVER['REMOTE_ADDR'] . "<br>\n");
      $this->WriteToLog("Debug: " . $this->debug . "<br>\n");

      $this->ShowDefaults();
      flush();
   }// end LogConnection


   private function LogFailure($ip)
   {
      $this->WriteToLog("<hr>");
      $this->WriteToLog("<strong>Fehler bei LDAP-Verbindung - " . date("d.m.Y  H:i:s") . "</strong><br>\n");
      $this->ShowDefaults();
      $this->WriteToLog("<hr>");
      $this->FlushLog(LOGFILE);
   }// LogFailure

   /*************************************************************************
   **   Hilfsroutinen                                                     **
   *************************************************************************/

   private function LogHeader($text)
   {
      /*log*/$this->now = microtime();
      /*Log*/$this->WriteToLog("<hr>");
      /*Log*/$this->WriteToLog("<strong>" . $text . " - " . date("d.m.Y  H:i:s") . "</strong><br>\n");
      /*Log*/$this->WriteToLog("<hr>");
   }// end LogHeader


   private function LogFooter($text)
   {
      /*Log*/$dauer = Duration($this->now, microtime());
      /*Log*/$this->WriteToLog("<hr>");
      /*Log*/$this->WriteToLog($text . " Duration: " . $dauer . " sec.<br>\n");
      /*Log*/$this->WriteToLog("<hr>");
   }// end LogFooter

   /*************************************************************************
   *************************************************************************
   **   PUBLIC:                                                           **
   **   Hauptroutinen, knnen von externem Skript aufgerufen werden       **
   *************************************************************************
   *************************************************************************/


   /*************************************************************************
    **  Funktionen die iprntman auf dem GServer verwenden                  **
    *************************************************************************/


   //------------------------------------------------------------------------------
   // Gibt eine Liste der Druckjobs fr $printer zurck, ermittelt mit iprntman
   // Relevante Zeilen in der Ausgabe sind mit * gekennzeichnet       // 11.01.2012
   //------------------------------------------------------------------------------
   public function GetJoblist($printer)
   {
      $this->WriteToLog("getJobList(" . $printer . ") - " . date("d.m.Y  H:i:s") . "<br>\n");
      $now = microtime();
      $error = false;

      unset($ausgabe);
      $command = "iprntman job $printer -s $this->ip -u $this->iprintuser -P ***** -w -f -l --accept-cert";
      $this->WriteToLog("  $command<br>\n");
      $command = "iprntman job $printer -s $this->ip -u $this->iprintuser -P $this->pwd -w -f -l --accept-cert";
      exec("sudo /opt/novell/bin/" . $command, $ausgabe);

      foreach($ausgabe as $value)
      {
         echo "*$value.<br>\r\n";
      }

      $dauer = Duration($now, microtime());
      $this->WriteToLog("<hr>");
      $this->WriteToLog("GetJoblist Duration: " . $dauer . " sec.<br>\n");
      $this->WriteToLog("<hr>");

      return !$error;
   }// GetJoblist

   //------------------------------------------------------------------------------
   // Mit iprntman pause-input und pause-output fr $printer steuern.
   // $action ist resume-input, pause-input, resume-output, pause-output //11.01.2012
   //------------------------------------------------------------------------------
   public function PausePrinter($printer, $action)
   {
      $this->WriteToLog("PausePrinter(" . $printer . ',' . $action . ") - " . date("d.m.Y  H:i:s") . "<br>\n");
      $now = microtime();
      $error = false;

      if(($action != 'pause-input') &&
      ($action != 'resume-input') &&
      ($action != 'pause-output') &&
      ($action != 'resume-output'))
      {
         $error = true;
         $this->WriteToLog("Fehler: Parameter $action falsch. Abbruch.<br>\n");
      }

      if(!$error)
      {
         unset($ausgabe);
         $command = "iprntman printer $printer -s $this->ip -u $this->iprintuser -P ***** -w -f --accept-cert --$action";
         $this->WriteToLog("  $command<br>\n");
         $command = "iprntman printer $printer -s $this->ip -u $this->iprintuser -P $this->pwd -w -f --accept-cert --$action";
         exec("sudo /opt/novell/bin/" . $command, $ausgabe);

         $dauer = Duration($now, microtime());
         $this->WriteToLog("<hr>");
         $this->WriteToLog("PausePrinter Duration: " . $dauer . " sec.<br>\n");
         $this->WriteToLog("<hr>");
      }
      return !$error;
   }// PausePrinter

   //------------------------------------------------------------------------------
   // Benutzetr zu Drucker hinzufgen oder entfernen mit iprntman
   // $action ist grant-access oder revoke-access                      //11.01.2012
   //------------------------------------------------------------------------------
   public function PrinterAccess($printer, $user, $action)
   {
      $this->WriteToLog("PrinterAccess(" . $printer . ',' . $user . ',' . $action . ") - " . date("d.m.Y  H:i:s") . "<br>\n");
      $now = microtime();
      $error = false;

      if(($action != 'grant-access') &&
      ($action != 'revoke-access'))
      {
         $error = true;
         $this->WriteToLog("Fehler: Parameter $action falsch. Abbruch.<br>\n");
      }

      if(!$error)
      {
         unset($ausgabe);
         $command = "iprntman printer $printer -s $this->ip -u $this->iprintuser -P ***** -w -f --accept-cert --$action $user";
         $this->WriteToLog("  $command<br>\n");
         $command = "iprntman printer $printer -s $this->ip -u $this->iprintuser -P $this->pwd -w -f --accept-cert --$action $user";
         exec("sudo /opt/novell/bin/" . $command, $ausgabe);

         $dauer = Duration($now, microtime());
         $this->WriteToLog("<hr>");
         $this->WriteToLog("PrinterAccess Duration: " . $dauer . " sec.<br>\n");
         $this->WriteToLog("<hr>");
      }
      return !$error;
   }// PausePrinter

   //------------------------------------------------------------------------------
   // Gibt Info zum Drucker zurck, ermittelt mit iprntman
   // Relevante Zeilen beginnen mit *                                 // 11.01.2012
   //------------------------------------------------------------------------------
   public function GetPrinterInfo($printer, $action)
   {
      $this->WriteToLog("GetPrinterInfo(" . $printer . ',' . $action . ") - " . date("d.m.Y  H:i:s") . "<br>\n");
      $now = microtime();
      $error = false;

      if(($action != 'info') &&
      ($action != 'property-info'))
      {
         $error = true;
         $this->WriteToLog("Fehler: Parameter $action falsch. Abbruch.<br>\n");
      }


      unset($ausgabe);
      $command = "iprntman printer $printer -s $this->ip -u $this->iprintuser -P ***** -w -f --$action --accept-cert";
      $this->WriteToLog("  $command<br>\n");
      $command = "iprntman printer $printer -s $this->ip -u $this->iprintuser -P $this->pwd -w -f --$action --accept-cert";
      // $this->WriteToLog("  $command<br>\n");

      exec("sudo /opt/novell/bin/" . $command, $ausgabe, $returnvar);
      

      if ($this->debug) {
        if ($returnvar==0) {
          echo '&nbsp;&nbsp;successfull<br>';
        }
        else {
          echo '&nbsp;&nbsp;Errorcode: '.$returnvar."<br>";
        }
        echo_rs("iprntman result:",$ausgabe);
      }

      foreach($ausgabe as $value)
      {
         echo "*$value.<br>\r\n";
      }

      $dauer = Duration($now, microtime());
      $this->WriteToLog("<hr>");
      $this->WriteToLog("GetPrinterInfo Duration: " . $dauer . " sec.<br>\n");
      $this->WriteToLog("<hr>");

      return !$error;
   }// GetPrinterInfo


   //------------------------------------------------------------------------------
   // Gibt die Liste der Drucker zurck, ermittelt mit iprntman
   //------------------------------------------------------------------------------
   public function GetPrinterList()
   {
       $this->WriteToLog("GetPrinterlist() - " . date("d.m.Y  H:i:s") . "<br>\n");
       $now = microtime();
       $error = false;
            
       unset($ausgabe);
       $command = "iprntman printer -l -u $this->iprintuser -P ***** -w -f --accept-cert";
       $this->WriteToLog("  $command<br>\n");
       $command = "iprntman printer -l -u $this->iprintuser -P $this->pwd -w -f --accept-cert";
       // $this->WriteToLog("  $command<br>\n");
       
       exec("sudo /opt/novell/bin/" . $command, $ausgabe, $returnvar);
       
       
       if ($this->debug) {
           if ($returnvar==0) {
               echo '&nbsp;&nbsp;successfull<br>';
           }
           else {
               echo '&nbsp;&nbsp;Errorcode: '.$returnvar."<br>";
           }
           echo_rs("iprntman result:",$ausgabe);
       }
       
       $dauer = Duration($now, microtime());
       $this->WriteToLog("<hr>");
       $this->WriteToLog("GetPrinterInfo Duration: " . $dauer . " sec.<br>\n");
       $this->WriteToLog("<hr>");
       
       return !$error;
   }// GetPrinterList
   
   
   //------------------------------------------------------------------------------
   // Lscht bei $printer den Druckjob mit $id mit iprntman         // 13.01.2012
   //------------------------------------------------------------------------------
   public function DeleteJob($printer, $id)
   {
      $this->WriteToLog("DeleteJob(" . $printer . ',' . $action . ") - " . date("d.m.Y  H:i:s") . "<br>\n");
      $now = microtime();
      $error = false;

      unset($ausgabe);
      $command = "iprntman job $printer -s $this->ip -u $this->iprintuser -P ***** -w -f -d $id --accept-cert";
      $this->WriteToLog("  $command<br>\n");
      $command = "iprntman job $printer -s $this->ip -u $this->iprintuser -P $this->pwd -w -f -d $id --accept-cert";
      exec("sudo /opt/novell/bin/" . $command, $ausgabe);

      foreach($ausgabe as $value)              // nur zum Ersttest
      {
         echo "*$value.<br>\r\n";
      }

      $dauer = Duration($now, microtime());
      $this->WriteToLog("<hr>");
      $this->WriteToLog("DeleteJob Duration: " . $dauer . " sec.<br>\n");
      $this->WriteToLog("<hr>");

      return !$error;
   }// DeleteJob



}// end class iPrintApi

?>
