<?php
/* Datum         Beschreibung
   21.06.2018    erste funktionierende Version
   21.06.2018    Erstellungsdatum
*/

/*************************************************************************
 **  Benutzerpasswort ndern                                            **
 **  Copyright Ulrich Frei 2018                                         **
 *************************************************************************
 **  ndert das Benutzerpasswort                                        **
 **  bergabeparameter:                                                 **                                 
 **  CN     : Fullname des Benutzers                                    **
 **  pwd    : neues Benutzerpasswort                                    ** 
 **  Caller : Fullname des am Client angemeldeten Benutzers             **
 **           Fr diesen Benutzer erfolgt eine etwaige                  **
 **           Berechtigungsprfung                                      **
 **  debug  : html-Ausgabe der Log-Eintrge. Zum Debug mittels          **
 **           Webseite. Schulkonsole: debug=0                           **
 **                                                                     **
 *************************************************************************/

require_once("../_common/inetapi.cfg.php");
require_once("../_common/utils.inc.php");

    if (!isset($_REQUEST['CN'])) {
      die('kann nicht direkt aufgerufen werden. HTML-Seite benutzen.');
    }

    $gvCN     = $_REQUEST['CN'];
    $gvPwd    = $_REQUEST['pwd'];
    $gvCaller = $_REQUEST['Caller'];
    $gvDebug  = $_REQUEST['debug'];
    
           
    if ($gvDebug) {
       require_once("../_common/htmlfunc.inc.php");
       htmlheader('novldap_ChangeUserPwd.php',true);

       echo '<strong>novldap_ChangeUserPwd "'.$gvCN.'"</strong>';
       echo "<hr>\n";
    }
    
    require_once("../_common/novldap.php");
    $novldap = new NovLdap ('10.1.1.32',$gvCaller, $gvDebug);
    if (!$novldap) {
        die("cannot connect to novldap");
    }
    else {
      $ok = true;  
      
      if ($gvDebug) {
          echo "<br>";
          echo "&Uuml;bergabeparameter:<br>";
          echo "Name: ". $gvCN.'<br>';
          echo "neues Passwort: ". $gvPwd.'<br>';
          echo "Caller: ". $gvCaller.'<br>';
          echo "<br>";
      }     
      
      
      // prfen, ob Benutzer existiert
      if ($ok) {

        if (!$novldap->objectExists($gvCN)) {
          echo "<B>Error: Benutzer existiert nicht</B>\r\n<br>";
          if ($gvDebug) { echo '<br>';}
          $ok = false; 
        }          
      }
      
      
    
      if ($ok) {
        $result = $novldap->set_attribute(dot2dn($gvCN,true),"userPassword",$gvPwd);
        if ($result) {
          echo "<br>Passwort ge&auml;ndert.\r\n";
          if ($gvDebug) { echo '<br>';}
        }
        else {
          echo "Error: Fehler beim &Auml;ndern des Passworts\r\n";
          if ($gvDebug) { echo '<br>';}
        }
      }
      
      $novldap->Close();
    }
    if ($gvDebug) {
       echo "<hr>";
       htmlfoot();
    }
?>
