<?php
/* Datum         Beschreibung
   26.04.2018    erste funktionierende Version
   03.04.2018    Erstellungsdatum
*/

/*************************************************************************
 **  Erstellen einer dynamischen Grupe                                  **
 **  Copyright Ulrich Frei 2018                                         **
 *************************************************************************
 **  Erstellt eine dynamische Gruppe                                    **
 **  bergabeparameter:                                                 **                                 
 **  CN     : Fullname der dynamischen Gruppe                           **
 **  BaseDN : OU fr Mitgliedersuche                                    ** 
 **  Caller : Fullname des am Client angemeldeten Benutzers             **
 **           Fr diesen Benutzer erfolgt eine etwaige                  **
 **           Berechtigungsprfung                                      **
 **  debug  : html-Ausgabe der Log-Eintrge. Zum Debug mittels          **
 **           Webseite. Schulkonsole: debug=0                           **
 **                                                                     **
 *************************************************************************/

require_once("../_common/inetapi.cfg.php");
require_once("../_common/utils.inc.php");

    if (!isset($_GET['CN'])) {
      die('kann nicht direkt aufgerufen werden. HTML-Seite benutzen.');
    }

    $gvCN     = $_GET['CN'];
    $gvBaseDN = $_GET['BaseDN'];
    $gvCaller = $_GET['Caller'];
    $gvDebug  = $_GET['debug'];
    
    $OU       = ContextFromFullname($gvCN);
    $Name     = Shortname($gvCN);
           
    if ($gvDebug) {
       require_once("../_common/htmlfunc.inc.php");
       htmlheader('novldap_CreateDynGroup.php',true);

       echo '<strong>novldap_CreateDynGroup "'.$gvCN.'"</strong>';
       echo "<hr>\n";
    }
    
    require_once("../_common/novldap.php");
    $novldap = new NovLdap ('10.1.1.32',$gvCaller, $gvDebug);
    if (!$novldap) {
        die("cannot connect to novldap");
    }
    else {
      $ok = true;  
      
      if ($gvDebug) {
          echo "<br>";
          echo "bergabeparameter:<br>";
          echo "Name: ". $gvCN.'<br>';
          echo "BaseDN: ". $gvBaseDN.'<br>';
          echo "Caller: ". $gvCaller.'<br>';
          echo "<br>";
      }     
      
      // prfen, ob Gruppe bereits existiert
      if ($novldap->objectExists($gvCN)) {        
        echo "Error: Gruppe existiert bereits\r\n<br>";
        if ($gvDebug) { echo '<br>';}
        $ok = false; 
          
      }
      
      // prfen, ob OU fr Gruppe existiert
      if ($ok) {

        if (!$novldap->objectExists($OU)) {
          echo "Error: $OU existiert nicht\r\n<br>";
          if ($gvDebug) { echo '<br>';}
          $ok = false; 
        }          
      }
      
      // prfen, ob BaseDN existriert
      if ($ok) {
        if (!$novldap->objectExists($gvBaseDN)) {
          echo "Error: $gvBaseDN existiert nicht\r\n<br>";
          if ($gvDebug) { echo '<br>';}
          $ok = false;
        }            
      }
      
      $BaseDN = dot2dn($gvBaseDN,false);
      if ($gvDebug) { echo "BaseDN LDAP: ".$BaseDN.'<br><br>'; }
      
      // Klasse1a.Schueler.Benutzer.LFB.SCHULEN.ml3
      // $ldapurl = "ldap:///ou=klasse1a,ou=schueler,ou=benutzer,ou=lfb,ou=schulen,o=ml3??one?(objectclass=inetOrgPerson)";
      
      $ldapurl = "ldap:///" . dot2dn($gvBaseDN,false) . "??one?(objectclass=inetOrgPerson)";
      
      $Attribs = array("objectClass" => "dynamicGroup",
                       "owner" => "cn=admin,ou=server,ou=dienste,o=ml3",
                       "memberQueryURL"  => $ldapurl);
           
      // if ($gvDebug) { echo_rs("Attribute",$Attribs); }
         
      if ($ok) {
        $result = $novldap->createObj(dot2dn($gvCN,true),$Attribs);
        if ($result) {
          echo "<br>Dynamische Gruppe erfolgreich angelegt.\r\n";
          if ($gvDebug) { echo '<br>';}
        }
        else {
          echo "Error: Fehler beim Anlegen der dynamischen Gruppe\r\n";
          if ($gvDebug) { echo '<br>';}
        }
      }
      
      $novldap->Close();
    }
    if ($gvDebug) {
       echo "<hr>";
       htmlfoot();
    }
?>
