<?php

/* Datum      Beschreibung
16.07.2018	nderung in WriteACLFile fr Squid OES 2018 Maske /255.255.255.255 -> /32
18.02.2012    Warnung bei Zeitintervall, Ursache behoben in function inZeitIntervall
28.12.2011    Angepasst an Strukturnderung
25.11.2010    nderung in PruefeWS  if is_arra($NWAdresses) ...
26.02.2010    WriteACLFile: Absicherung bei leerer $acl_lines
		PruefeWS: Netzwerkadressen werden aus FNETADDR
		und aus FNETADDR2 zusammengetragen
10.02.2010    nderungen in PruefeWS wegen Indexfehler bei
		nicht vorhandener Netzwerkadresse
01.04.2009    squid reload nur bei nderungen an ACL_FILE
		120s-Timeout in WriteACLFile eingefhrt beim
		Versuch ACL_FILE zu ffnen.
*/

/*************************************************************************
**            Internetsperre fr paedML Novell 3                       **
*************************************************************************
**                  Copyright Ulrich Frei 2010                         **
*************************************************************************/
// Version
define("VERSION", "28.12.2011/Fr.");

// LDAP-Einstellungen
require_once("../_common/inetapi.cfg.php");
require_once("../_common/utils.inc.php");

// Attribute der Arbeitsstationen fr Internetsperre
define("FSPERRE", "ou");// Abteilung
define("FINTERVALLE", "o");// Organisation
define("FCOUNTDOWN", "l");// Standort
define("FNETADDR", "wmNetworkAddress");// 26.02.2010
define("FNETADDR2", "networkAddress");// 26.02.2010

define("FUSER", "wmNAMEUser");
define("FWORKSTATION", "Computer");// 29.12.2011

// Fr Squid-ACL
define("ACL_FILE", "ispallowed.acl");
// define("ACL_FILE",ACL_PATH."ispallowed.acl");       // 29.12.2011
// Verlegung der ACL geplant heraus aus htdocs

// Debug
define("DEBUG_HEUTE", "SA");
define("DEBUG_TIME", "12:30");
define("LOGFILE", LOG_PATH . "inetapi.log");
//define("MAX_LOGSIZE",1048576);
define("MAX_LOGSIZE", 1000000);

/*************************************************************************
**   Allgemeine Routinen                                               **
*************************************************************************/
// Berechnet Zeitdauer. Erwartet Zeit im Format von microtime()
/* in utils.inc.php
function Duration($von,$bis) {
$arr = explode(" ",$von);
$tvon = (float) $arr[1] + $arr[0];
$arr = explode(" ",$bis);
$tbis = (float) $arr[1] + $arr[0];
return($tbis-$tvon);
} // end Duration


// wandelt binre IP-Adresse in dezimale dot-Notation um
function LDAPNetAddr ($binaddr) {
$hexaddr = bin2hex($binaddr);
$ip      = hexdec(substr($hexaddr,8,2));
$ip     .= "." . hexdec(substr($hexaddr,10,2));
$ip     .= "." . hexdec(substr($hexaddr,12,2));
$ip     .= "." . hexdec(substr($hexaddr,14,2));
return($ip);
} // end LDAPNetAddr

// wandelt LDAP-Notation in Dot-Notation um
function dn2dot ($dn) {
$dn = ldap_dn2ufn($dn);
$dn = str_replace(',','.',$dn);
$dn = str_replace(' ','',$dn);
return($dn);
} // end dn2dot

// wandelt Dot-Notation in LDAP-Notation um
function dot2dn($fullname,$isCN) {
if ($fullname=="") return("");
if (stristr($fullname,",")) return($fullname);  // ist nicht dot
if (stristr($fullname,"=")) return($fullname);  // ist nicht dot

$array = explode(".",$fullname);
if (count($array)==1)                          // nur ein item
if ($isCN) return("cn=".$array[0]); else return("o=".$array[0]);

if ($isCN) $dn = "cn=".$array[0].","; else $dn = "ou=".$array[0].",";
$size = count($array);
for ($i=1;$i<$size-1;$i++) {                 // -1, da letztes="o" separat behandelt
$dn = $dn."ou=".$array[$i].",";
}
$dn = $dn.'o='.$array[$size-1];
return($dn);
} // end dot2dn

// liefert den cn-Teil bei LDAP-Notation, bei Dot-Notation den ersten Teil
function Shortname($fullname) {
if ($fullname=="") return('');
if (strpos($fullname,".")) {
$array = explode(".",$fullname,2);
}
else {
if (strtoupper(substr($fullname,0,2))=="CN")
{ $array = explode(",",$fullname,2);}
else
{ $array[0]=""; $array[1] = $fullname;}
}
return($array[0]);
} // Shortname

// liefert den Context
function ContextFromFullname($fullname) {
if ($fullname=="") return('');
if (strpos($fullname,".")) {
$array = explode(".",$fullname,2);
}
else {
if (strtoupper(substr($fullname,0,2))=="CN")
{ $array = explode(",",$fullname,2);}
else
{ $array[1] = $fullname;}
}
return($array[1]);
} // ContextFromFullname

function isIP ($ip) {
$arr = explode('.',$ip);
if (count($arr)==4) return(true); else return(false);
}

function isInArray($ar, $item) {
foreach ($ar as $value) {
if ($item==$value) return(true);
}
return(false);
} // isInArray

auskommentiert, da in ../_common/utils.inc.php*/

/*************************************************************************
*************************************************************************
**   Klasse InetApi                                                    **
*************************************************************************
*************************************************************************/
class InetApi
{
   var $ldap;
   var $bind_results;
   var $userscope;
   var $MustCountdown;
   var $caller;

   var $IPTables = array();

   // fr Squid
   var $IPListAll = array();
   var $IPListAllowed = array();

   // Logfile und Debug
   //var $LOGFILE;

   var $fp_log;// Filepointer Logfile
   var $debug;
   var $LogBuf = array();

   // Konstruktor
   function InetApi($ip, $caller, $debug)
   {
      $this->caller = $caller;
      $this->userscope = LDAP_BASE;
      $this->debug = $debug;
      if($ip == "")
      {
         $ip = LDAP_SERVER_IP;
      }
      if(!isIP($ip))
      {
         $ip = LDAP_SERVER_IP;
      }
      $this->ldap = ldap_connect($ip)or die('Fehler bei ldap_connect');

      $this->bind_results = ldap_bind($this->ldap, LDAP_USER, inetlockuser_getpwd(INETLOCKUSER_PWD));
      if(!$this->bind_results)
      {
         LogFailure($ip);
         die('Benutzer kann sich nicht mit ldap verbinden');
      }
      $this->LogConnection($ip);
   }// end NovLDAP

   // Destruktor
   function Close()
   {
      $this->WriteToLog("LDAP connection terminated, InetApi closed - " . date("d.m.Y  H:i:s") . "<br>");
      $this->FlushLog(LOGFILE);
      ldap_close($this->ldap);
   }// end  Close

   /*************************************************************************
   **   Zugriff auf Parameter, Logging                                    **
   *************************************************************************/

   function FlushLog($fnam)
   {
      if($this->debug) echo "Writing Logfile $fnam<br>";
      $logbak = explode(".", $fnam);
      $logres = $logbak['0'] . ".bak";

      if(file_exists($fnam))
      {
         $mode = 'a';
         if(filesize($fnam) > MAX_LOGSIZE)
         {
            // Backup-File lschen
            if(file_exists($logres))
            {
               unlink($logres);
            }
            copy($fnam, $logres);
            $mode = 'w';
            unlink($fnam);
         }
      }
      else
      {
         $mode = 'w';
      }

      if(!$fp = fopen($fnam, $mode))
      {
         echo "Logdatei $fname kann nicht geffnet werden<br>\n";
      }
      else
      {
         flock($fp, 2);

         foreach($this->LogBuf  as $value)
         {
            fputs($fp, $value);
         }
         fputs($fp, "\n\n\n\n");

         flock($fp, 3);
         fclose($fp);
      }
   }// end CloseLog

   function WriteToLog($line)
   {
      if($this->debug) echo str_replace(' ', '&nbsp;', $line);
      if($line == "<hr>") $line = str_pad("", 90, "-") . "\n";
      if($line == "<HR>") $line = str_pad("", 90, "-") . "\n";
      $this->LogBuf[] = strip_tags($line);
   }// WriteToLog

   function setDebug($on)
   {
      $this->debug = $on;
   }// end setDebug

   function ShowDefaults()
   {
      $this->WriteToLog("Voreinstellungen:<br>\n");
      $this->WriteToLog("LDAP_SERVER_IP: " . LDAP_SERVER_IP . "<br>\n");
      $this->WriteToLog("LDAP_USER: " . LDAP_USER . "<br>\n");
      $this->WriteToLog("LDAP_BASE: " . LDAP_BASE . "<br>\n");
      $this->WriteToLog("FSPERRE: " . FSPERRE . "<br>\n");
      $this->WriteToLog("FINTERVALLE: " . FINTERVALLE . "<br>\n");
      $this->WriteToLog("FCOUNTDOWN: " . FCOUNTDOWN . "<br>\n");
      $this->WriteToLog("FNETADDR: " . FNETADDR . "<br>\n");
      $this->WriteToLog("FUSER: " . FUSER . "<br>\n");
      if(USER_AUTH == 1) $this->WriteToLog("USER_AUTH: TRUE<br>\n");
      else $this->WriteToLog("USER_AUTH: FALSE<br>\n");
      $this->WriteToLog("LOGFILE: " . LOGFILE . "<br>\n");
      $this->WriteToLog("ACL_FILE: " . ACL_FILE . "<br>\n");
   }// showDefaults

   function LogFailure($ip)
   {
      $this->WriteToLog("<hr>");
      $this->WriteToLog("<strong>Fehler bei LDAP-Verbindung - " . date("d.m.Y  H:i:s") . "</strong><br>\n");
      $this->WriteToLog("LDAP-Server: " . $ip . "<br>\n");
      $this->WriteToLog("LDAP-User:   " . LDAP_USER . "<br>\n");
      $this->WriteToLog("LDAP-BASE:   " . $this->userscope . "<br>\n");
      $this->WriteToLog("Debug: " . $this->debug . "<br>\n");

      $this->ShowDefaults();
      $this->WriteToLog("<hr>");
      $this->FlushLog(LOGFILE);
   }// LogFailure

   function LogConnection($ip)
   {
      $this->WriteToLog("<hr>");
      $this->WriteToLog("inetapi.php - Version " . VERSION . "<br>\n");
      $this->WriteToLog("<hr>");
      $this->WriteToLog("<strong>LDAP-Connection opened - " . date("d.m.Y  H:i:s") . "</strong><br>\n");
      $this->WriteToLog("Aufgerufen durch: " . $this->caller . " von IP: " . $_SERVER['REMOTE_ADDR'] . "<br>\n");
      $this->WriteToLog("LDAP-Server: " . $ip . "<br>\n");
      $this->WriteToLog("LDAP-User:   " . LDAP_USER . "<br>\n");
      $this->WriteToLog("LDAP-BASE:   " . $this->userscope . "<br>\n");
      $this->WriteToLog("Debug: " . $this->debug . "<br>\n");

      $this->ShowDefaults();
      flush();
   }// end LogConnection


   /*************************************************************************
   **   eDirectory                                                        **
   *************************************************************************/

   function set_attribute($obj, $attribute, $value)
   {
      $this->WriteToLog("    set_attribute( " . $obj . "; " . $attribute . "; " . $value . " )<br>\n");
      $entry[$attribute] = $value;
      ldap_mod_replace($this->ldap, $obj, $entry);
   }// end set_attribute

   /*************************************************************************
   **   Hilfsroutinen                                                     **
   *************************************************************************/

   // prft, ob jetzt ein Zeitintervall aktiv ist.
   function inZeitIntervall($intervalle)
   {
      $inIntervall = false;

      setlocale(LC_TIME, "de_DE");
      $Heute = strtoupper(substr(strftime("%a"), 0, 2));
      $Time = DATE("H") . ":" . DATE("i");

      /*      if ($this->debug){
      $Heute = DEBUG_HEUTE;
      $Time  = DEBUG_TIME;
      echo "$Heute $Time<br>\n";
      }
      */
      if(count($intervalle) == 0)
      {
         /*Log*/$this->WriteToLog("  keine Zeitsperre<br>\n");
         return($inIntervall);
      }

      /*Log*/$this->WriteToLog(' Zeitsperre: ');

      // /*Log*/ $this->WriteToLog("  gesperrt ");             // 10.02.2010

      if(is_Array($intervalle))
      {
         for($i = 0; $i < count($intervalle) - 1; $i++)
         {// 21.02.2012 letzter Eintrag ist [count]
            // foreach ($intervalle as $intervall) {               // 18.02.2012
            $intervall = $intervalle[$i];
            if($intervall == "") continue;
            if(strlen($intervall) < 13) continue;// 18.02.2012

            $WTag = strtoupper(substr($intervall, 0, 2));
            $von = substr($intervall, 3, 5);
            $bis = substr($intervall, 9, 5);

            /*Log*/$this->WriteToLog($intervall . ", ");

            if($WTag != $Heute) continue;
            if($Time < $von) continue;
            if($Time >= $bis) continue;

            $inIntervall = true;
            break;
         }// foreach
      }
      else
      {
         $intervall = $intervalle;
         if(($intervall != "")AND(strlen($intervall) >= 13))              // 21.02.2012
         {
            $WTag = strtoupper(substr($intervall, 0, 2));
            $von = substr($intervall, 3, 5);
            $bis = substr($intervall, 9, 5);
          /*Log*/$this->WriteToLog($intervall . ", ");
            if($WTag != $Heute) continue;
            if($Time < $von) continue;
            if($Time >= $bis) continue;
            $inIntervall = true;
         }
      }
      /*Log*/$this->WriteToLog("<br>\n");

      /*Log*/if($inIntervall)
         /*Log*/$this->WriteToLog("  InZeitintervall: true<br>\n");
      /*Log*/else
         /*Log*/$this->WriteToLog("  InZeitintervall: false<br>\n");

      return($inIntervall);
   }// end inZeitIntervall

   //-------------------------------------------------------------------------
   // prft, ob der Benutzer $user an der Arbeitsstation $ws angemeldet ist
   function checkUserConnection($user, $ws)
   {
      $angemeldet = false;

      /*Log*/$this->WriteToLog("  checkUserConnection for " . $user . "<br>\n");

      $cn = dn2dot(Shortname($user));
      $ou = ContextFromFullname($user);

      $attr_names = array("cn", "zenwmLoggedInWorkstation");
      $filter = "(&(objectclass=inetOrgPerson)(cn=$cn))";

      $results = ldap_search($this->ldap, $ou, $filter, $attr_names);
      if($results)
      {
         $entry = ldap_first_entry($this->ldap, $results);
         while($entry)
         {
            $dn = ldap_get_dn($this->ldap, $entry);

            $values = ldap_get_values($this->ldap, $entry, "zenwmLoggedInWorkstation");
            /*Log*/$this->WriteToLog("    zenwmLoggedInWorkstation: " . $values[0] . "<br>\n");
            if($values[0] == $ws)
            {
               $angemeldet = true;
               break;
            }
            $entry = ldap_next_entry($this->ldap, $entry);
         }
      }// if ($result)

      return($angemeldet);
   }// end checkUserConnection


   /*************************************************************************
   **   Zugriff auf IPTables                                              **
   *************************************************************************/
   function inIPTables($ip)
   {
      $found = false;
      foreach($this->IPTables  as $value)
      {
         if(stristr($value, " $ip/"))
         {
            $found = true;
            break;
         }
      }// foreach
      return($found);
   }// end inIPTables


   function addToIPTables($ip)
   {// freigeben
      // Pruefen, ob $ip bereits in IPtables, wenn ja fertig
      if($this->inIPTables($ip))
      {
         /*Log*/$this->WriteToLog("  " . $ip . "  found in IPTables, Internet ist bereits frei<br>\n");
         return(false);
      }

      unset($ausgabe);
      //      $command = "iptables -A FORWARD -i eth0 -o eth1 -s $ip -m state --state NEW -j ACCEPT";
      $command = "fw-addrules add $ip";
      // $stream = ssh2_exec($this->sshConnection, $command);
      exec("sudo /usr/sbin/" . $command, $ausgabe);

      /*Log*/$this->WriteToLog("  " . $command . "<br>\n");
      /*Log*/foreach($ausgabe as $value)
      {
         $this->WriteToLog("  " . $value . "<br>\n");
      }
      /*Log*/$this->WriteToLog("  " . $ip . " wurde nun freigegeben<br>\n");

      return(true);
   }// end addToIPTables

   function removeFromIPTables($ip)
   {// sperren
      // Pruefen, ob $ip in IPtables, wenn nein fertig
      if(!$this->inIPTables($ip))
      {
         /*Log*/$this->WriteToLog("  " . $ip . " not found in IPTables, Internet ist bereits gesperrt<br>\n");
         return(false);
      }

      unset($ausgabe);
      //      $command = "iptables -D FORWARD -i eth0 -o eth1 -s $ip -m state --state NEW -j ACCEPT";
      // $stream = ssh2_exec($this->sshConnection, $command);
      $command = "fw-addrules remove $ip";
      exec("sudo /usr/sbin/" . $command, $ausgabe);

      /*Log*/$this->WriteToLog("  " . $command . "<br>\n");
      /*Log*/foreach($ausgabe as $value)
      {
         $this->WriteToLog("  " . $value . "<br>\n");
      }
      /*Log*/$this->WriteToLog("  " . $ip . " wurde nun gesperrt<br>\n");

      return(true);
   }// end addToIPTables

   /*************************************************************************
   **   PruefeWS                                                          **
   **                                                                     **
   **   Status der einzelne Arbeitsstation ermitteln und                  **
   **   in IPTables freigeben oder sperren                                **
   *************************************************************************/

   function PruefeWS($entry)
   {
      $temp = array();
      $NWAdresses = array();// 25.11.2010

      $ws = ldap_get_dn($this->ldap, $entry);// Arbeitsstation

      /*Log*/$this->WriteToLog("<strong>function PruefeWS ( " . dn2dot($ws) . " )</strong><br>\n");

      $temp = ldap_get_values($this->ldap, $entry, FSPERRE);// Sperrstatus PL oder PF, wenn leer PF
      if(count($temp) > 0) $Sperre = $temp[0];
      if($Sperre == "") $Sperre = "PL";
      /*Log*/$this->WriteToLog("  Sperre = " . $Sperre . ",");

      $temp = ldap_get_values($this->ldap, $entry, FCOUNTDOWN);// aktiv bei >0, wenn leer 0
      if(count($temp) > 0) $Countdown = (int)$temp[0];
      if($Countdown == "") $Countdown = 0;
      /*Log*/$this->WriteToLog("  Countdown = " . $Countdown . ",");//."<br>\n");

      // Ermittelt den bei WS eingetragenen Benutzer
      if(USER_AUTH)
      {
         $temp = @ldap_get_values($this->ldap, $entry, FUSER);
         if(count($temp) > 0) $user = $temp[0];
      }

      $Intervalle = @ldap_get_values($this->ldap, $entry, FINTERVALLE);// wenn leer kein Intervall

      $Addr = @ldap_get_values($this->ldap, $entry, FNETADDR);
      for($i = 0; $i < count($Addr) - 1; $i++)
      {
         $value = $Addr[$i];
         if(isIP($value))
         {
            $NWAdresses[] = $value;
         }
      }

      $Addr = @ldap_get_values($this->ldap, $entry, FNETADDR2);
      for($i = 0; $i < count($Addr) - 1; $i++)
      {// 10.02.2010 LDAP liefert in letztem Item die Anzahl
         $value = LDAPNetAddr($Addr[$i]);
         if(isIP($value))
         {
            $NWAdresses[] = $value;
         }
      }

      if(is_array($NWAdresses))
      {// 25.11.2010/Fr.
         $NWAdresses = array_unique($NWAdresses);
      }

      $gesperrt = true;// default

      if($Sperre == "PF") $gesperrt = false;

      if(USER_AUTH)
      {
         if($user != "")
         {
            $angemeldet = $this->checkUserConnection($user, $ws);
            /*Log*/if($angemeldet)
               /*Log*/$this->WriteToLog("  Benutzer ist angemeldet<br>\n");
            /*Log*/else
               /*Log*/$this->WriteToLog("  kein Benutzer angemeldet<br>\n");

         }
      }// of if USER_AUTH

      if($this->inZeitIntervall($Intervalle)) $gesperrt = true;

      if($Countdown > 0)
         if($this->MustCountdown)
         {
            $Countdown--;
            $this->WriteToLog("  Countdown herunterzhlen - now " . $Countdown . "  <br>");
            // Attribut zurckschreiben
            $this->set_attribute($ws, FCOUNTDOWN, (string)$Countdown);
         }

      if($Countdown > 0)
      {
         $gesperrt = !$gesperrt;
      }

      // Freigabe nur, wenn Benutzer am eDirectory angemeldet (optional)
      if(USER_AUTH)
         if(!$angemeldet) $gesperrt = true;

      if($gesperrt)
      {
         // fr alle Netzwerkadressen
         /*Log*/$this->WriteToLog("  Internetstatus: gesperrt<br>\n");
         for($i = 0; $i < count($NWAdresses); $i++)
         {// 26.02.2010
            $value = $NWAdresses[$i];
            if(!isIP($value)) continue;
            /*Log*/$this->WriteToLog("  IP: $value gesperrt<br>\n");
            $this->removeFromIPTables($value);// sperren
            $this->IPListAll[] = $value;// alle IPs in Liste aufnehmen
         }// foreach
      }
      else
      {
         // fr alle Netzwerkadressen
         /*Log*/$this->WriteToLog("  Internetstatus: freigegeben<br>\n");
         for($i = 0; $i < count($NWAdresses); $i++)
         {// 26.02.2010
            $value = $NWAdresses[$i];
            if(!isIP($value)) continue;
            /*Log*/$this->WriteToLog("  IP: $value freigegeben<br>\n");
            $this->addToIPTables($value);// freigeben
            $this->IPListAll[] = $value;// alle IPs in Liste aufnehmen
            $this->IPListAllowed[] = $value;// freigegebene IPs in Liste aufnehmen
         }// foreach
      }
      /*Log*/$this->WriteToLog("end function PruefeWS<br>\n");
   }// end PruefeWS


   /*************************************************************************
   **   WriteACLFile                                                      **
   **                                                                     **
   **   Wenn base=UserScope                                               **
   **      ACL-Inhalt lschen                                             **
   **      IPListAllowed in ACL-File schreiben                            **
   **   sonst                                                             **
   **      Vorhandenes ACL-File einlesen                                  **
   **      ACL-Inhalt lschen                                             **
   **      Vorhandene Eintrge in ACL-File schreiben, wenn                **
   **         wenn sie nicht in IPListAll enthalten sind.                 **
   **      IPListAllowed in ACL-File schreiben                            **
   *************************************************************************/

   function WriteACLFile($base)
   {
      /*Log*/$this->WriteToLog("<strong><br>\nfunction WriteACLFile ( " . $base . " )</strong><br>\n");

      $this->IPListAllowed = array_unique($this->IPListAllowed);
      $this->IPListAll = array_unique($this->IPListAll);// 26.02.2010

      /*Log*/$this->WriteToLog("  IPListAll:<br>\n");
      /*Log*/foreach($this->IPListAll  as $value)
      {
         $this->WriteToLog("    " . $value . "<br>\n");
      }
      /*Log*/$this->WriteToLog("  IPListAllowed:<br>\n");
      /*Log*/foreach($this->IPListAllowed  as $value)
      {
         $this->WriteToLog("    " . $value . "<br>\n");
      }


      $timeout = 0;// 01.04.2009
      while(!$f = fopen(ACL_FILE, 'a+'))
      {
         sleep(1);// 1 Sekunde Wartezeit
         $timeout = $timeout + 1;
         if($timeout > 120) break;
      }// of while

      if(!$f)
      {// 01.04.2009
         /*Log*/$this->WriteToLog("  Datei " . ACL_FILE . " kann auch nach 120s nicht geffnet werden.<br>\n\n");
         return(false);
      }
      else
      {
         flock($f, 2);
         $md5_alt = md5_file(ACL_FILE);

         if($base == $this->userscope)
         {
            // bei Aufruf ohne Raumangabe. Alle WS im Baum erfasst
            /*Log*/$this->WriteToLog("  Keine Raumangabe<br>\n");
            /*Log*/$this->WriteToLog("  Eintrge in " . ACL_FILE . " :<br>\n");// 10.02.2010

            ftruncate($f, 0);// leert die Datei

            foreach($this->IPListAllowed  as $value)
            {
               if($value != "")
               {
                  /*Log*/$this->WriteToLog("    " . $value . "<br>\n");
                  fputs($f, $value . "/32\n");					// 16.07.2018 Maske gendert
                  fputs($f, $value . "/255.255.255.255\n");			// fr Squid OES 2018
               }
            }// foreach
         }
         else
         {
            // bei Aufruf mit Raumangabe
            // Inhalt der ACL-Datei in array $acl_lines einlesen
            /*Log*/$this->WriteToLog("  ACL-Datei " . ACL_FILE . " lesen:<br>\n");
            unset($acl_lines);
            while(!feof($f))
            {
               $line = trim(fgets($f, 100));
               if($line != "")
               {
                  /*Log*/$this->WriteToLog("    " . $line . "<br>\n");
                  $acl_lines[] = $line;
               }
            }// of while
            if(!isset($acl_lines)) $acl_lines[] = '##';// Elefant in Afrika, gegen leere Datei 26.02.2010
            if(count($acl_lines) == 0) $acl_lines[] = '##';// Elefant in Afrika, gegen leere Datei
            $acl_lines = array_unique($acl_lines);
            ftruncate($f, 0);// leert die Datei
            // alle Zeilen von acl_lines berprfen
            // nur Zeilen bertragen, die nicht zum Raum gehren
            /*Log*/$this->WriteToLog("  ACL-Inhalt bertragen:<br>\n");

            foreach($acl_lines as $item)
            {
               $p = strpos($item, '#');
               if(!($p === false))
               {
                  continue;// Kommentare bergehen
               }

               /*Log*/$this->WriteToLog("    " . $item);
               // if (!isInArray($this->IPListAll,$item)) {
               if(!isInArray($this->IPListAll, substr($item, 0, strpos($item, '/'))))
               {
                  /*Log*/$this->WriteToLog(" bertragen");
                  fputs($f, $item . "\n");
               }
               /*Log*/else
               {
                  /*Log*/$this->WriteToLog(" entfernt (eigener Raum)");
                  /*Log*/}
               /*Log*/$this->WriteToLog("<br>\n");
            }// foreach

            // Alle IPs aus IPListallowed anfgen
            /*Log*/$this->WriteToLog("  Erlaubte IPs bertragen<br>\n");

            foreach($this->IPListAllowed  as $value)
            {
               if($value != "")
               {
                  $this->WriteToLog("    " . $value . "<br>\n");
                  fputs($f, $value . "/32\n");				// 16.07.2018 Maske gendert
                  // fputs($f, $value . "/255.255.255.255\n");		// fr Squid OES 2018

               }
            }// foreach
         }
         flock($f, 3);// wir bei Skriptende auch automatisch freigegeben
         fclose($f);// falls unlock oder close ausfallen
         $md5_neu = md5_file(ACL_FILE);
         /*Log*/$this->WriteToLog("     MD5: " . $md5_alt . " <br>\n");
         /*Log*/$this->WriteToLog("     MD5: " . $md5_neu . " <br>\n");
         return($md5_neu != $md5_alt);
      }// else
      /*Log*/$this->WriteToLog("end function WriteACLFile<br>\n");
   }// end WriteACLFile


   /*************************************************************************
   **   CheckWorkstations                                                 **
   **                                                                     **
   **   Hauptroutine, wird von Skript aufgerufen und steuert die ganze    **
   **   Arbeit                                                            **
   *************************************************************************/
   function CheckWorkstations($base, $countdown)
   {
      $now = microtime();

      /*Log*/$this->WriteToLog("<hr>");
      /*Log*/$this->WriteToLog("<strong>CheckWorkstations(" . $base . "," . $countdown . ") - " . date("d.m.Y  H:i:s") . "</strong><br>\n");
      /*Log*/$this->WriteToLog("<hr>");

      if($base == "")
      {
         $base = $this->userscope;
      }
      $base = dot2dn($base, false);

      $this->MustCountdown = false;
      if($countdown == 1)
      {
         if(strtoupper($this->caller) == "CRON")
         {
            $this->MustCountdown = true;
         }
      }

      if($this->MustCountdown)
      {
         /*Log*/$this->WriteToLog("Countdown erfolgt<br>\n");
      }
      else
      {
         /*Log*/$this->WriteToLog("kein Countdown<br>\n");
      }

      unset($this->IPTables);
      $command = "iptables-save -tfilter";
      exec("sudo /usr/sbin/" . $command, $this->IPTables);

      /*Log*/$this->WriteToLog("<strong>" . $command . "</strong><br>\n");
      /*Log*/$i = 1;
      /*Log*/foreach($this->IPTables  as $value)
      {
         /*Log*/$this->WriteToLog($i . ".) " . $value . "<br>\n");
         /*Log*/$i++;
         /*Log*/}
      /*Log*/$this->WriteToLog("<br>\n");

      $attr_names = array("cn", FNETADDR, FNETADDR2, FSPERRE, FINTERVALLE, FCOUNTDOWN, FUSER);
      $results = ldap_search($this->ldap, $base, "objectclass=" . FWORKSTATION, $attr_names);

      $command = 'ldap_search(' . $this->ldap . ',' . $base . ',objectclass=' . FWORKSTATION . ',' . $attr_names . ')';// 29.12.2011
      /*Log*/$this->WriteToLog("<strong>" . $command . "</strong><br>\n");

      if(!$results)
      {
         /*Log*/$this->WriteToLog("Keine Arbeitsstation gefunden<br>\n");
         return(0);
      }

      $count = ldap_count_entries($this->ldap, $results);
      /*Log*/$this->WriteToLog($count . " Arbeitsstationen unterhalb von " . dn2dot($base) . "<br>\n");

      $wscount = 0;
      $entry = ldap_first_entry($this->ldap, $results);
      while($entry)
      {
         $wscount++;
         $dn = ldap_get_dn($this->ldap, $entry);

         /*Log*/$this->WriteToLog("<br>\n<i>" . dn2dot($dn) . "<br>\n");
         /*Log*/foreach($attr_names as $attr)
         {
            /*Log*/$this->WriteToLog($attr . ": ");
            /*Log*/$temp = @ldap_get_values($this->ldap, $entry, $attr);
            /*Log*/for($i = 0; $i < count($temp) - 1; $i++)
            {// LDAP liefert in letztem Item die Anzahl
               if($attr == FNETADDR)
               {
                  $this->WriteToLog($temp[$i] . "; ");
               }
               else
                  if($attr == FNETADDR2)
                  {
                     $this->WriteToLog(LDAPNetAddr($temp[$i]) . "; ");
                  }// 10.02.2010
               else
               {
                  $this->WriteToLog($temp[$i] . "; ");
               }
               /*Log*/}
            /*Log*/}// foreach
         /*Log*/$this->WriteToLog("</i><br>\n");

         $this->PruefeWS($entry);
         $entry = ldap_next_entry($this->ldap, $entry);
      }// end while ($entry)

      ldap_free_result($results);

      if($this->WriteACLFile($base))
      {// 01.04.2009
         unset($ausgabe);
         exec("sudo /usr/sbin/squid -k reconfigure", $ausgabe);
         /*Log*/$this->WriteToLog("<br><strong>squid -k reconfigure</strong><br>");
         /*Log*/$i = 1;
         /*Log*/foreach($ausgabe as $value)
         {
            /*Log*/$this->WriteToLog($i . ".) " . $value . "<br>\n");
            /*Log*/$i++;
            /*Log*/}
      }
      else
      {
         /*Log*/$this->WriteToLog("<br><strong>No changes in " . ACL_FILE . ", no squid reload required.</strong><br>");// 01.04.2009
      }

      /*Log*/unset($ausgabe);
      /*Log*/$command = "iptables-save -tfilter";
      /*Log*/exec("sudo /usr/sbin/" . $command, $ausgabe);

      /*Log*/$this->WriteToLog("<br>\n");
      /*Log*/$this->WriteToLog("<strong>" . $command . "</strong><br>\n");
      /*Log*/$i = 1;
      /*Log*/foreach($ausgabe as $value)
      {
         /*Log*/$this->WriteToLog($i . ".) " . $value . "<br>\n");
         /*Log*/$i++;
         /*Log*/}
      /*Log*/$dauer = Duration($now, microtime());
      /*Log*/$this->WriteToLog("<hr>");
      /*Log*/$this->WriteToLog("CheckWorkstations Duration: " . $dauer . " sec.<br>\n");
      /*Log*/$this->WriteToLog("<hr>");


      return($wscount);
   }// CheckWorkstations


}// end class InetApi

?>