<?php
/* Datum      Beschreibung
22.02.2019    Erstellungsdatum
*/

/************************************************************************
**  Auslesen eines Attributes                               		   **
**  Copyright Ulrich Frei 2019                                         **
*************************************************************************
**  OBJ       : NDS-Objekt, bei dem Attribut gendert werden soll      **
**  Attribute : auszulesendes Attribut    							   **
**  isCN	  : LDAP-Objekt ist CN			                           **
**  Caller    : Fullname des am Client angemeldeten Benutzers          **
**              Fr diesen Benutzer erfolgt eine etwaige               **
**              Berechtigungsprfung                                   **
**  debug     : html-Ausgabe der Log-Eintrge. Zum Debug mittels       **
**              Webseite. Schulkonsole: debug=0                        **
**                                                                     **
*************************************************************************/

require_once("../_common/utils.inc.php");

if (!isset($_REQUEST['Caller']))
{
      die('kann nicht direkt aufgerufen werden. HTML-Seite benutzen.');
}

$gvObject    = $_REQUEST['OBJ'];
$gvAttribute = $_REQUEST['Attribute'];
$gvCaller    = $_REQUEST['Caller'];
$gvDebug     = $_REQUEST['debug'];

if (!isset($_REQUEST['isCN'])) {
  $gvIsCN = 1;	
} else {
  $gvIsCN    = $_REQUEST['isCN'];	
}	

if($gvDebug)
{
   require_once("../_common/htmlfunc.inc.php");
   htmlheader('novldap_getAttribute.php', true);

   echo '<strong>novldap_getAttribute "' . $gvObject . ', '.$gvAttribute .'"</strong>';
   echo "<hr>\n";
}

require_once("../_common/novldap.php");
$novldap = new NovLdap('10.1.1.32', $gvCaller, $gvDebug);
if(!$novldap)
{
   die("cannot connect to novldap");
}
else
{ 
  if (stristr($gvObject,".")) { 
    $gvObject = dot2dn($gvObject,$gvIsCN);
  }	
  
  $result = $novldap->get_attribute($gvObject,$gvAttribute);
  if ($result) {
	echo_rs($gvAttribute,$result);  
	if ($gvDebug) { echo '<br>';}
  }	  
  else {
    echo "Fehler beim Anzeigen des Objekts\r\n";
    if ($gvDebug) { echo '<br>';}
  }	  
	  
  $novldap->Close();
}
if($gvDebug)
{
   echo "<hr>";
   htmlfoot();
}
?>
