#!/bin/bash
# ----------------------------------
# Migrationstool - heißt jetzt opsi-Backup-and-Restore
# Geeignet für Backup und Restore
# Version 1.0.9 Ew
# Datum: 22.07.2015
# - Alles wird umgezogen. Keine Dateien werden ausgeschlossen.
# ----------------------------------
# Stand & Version bitte nach jeder (!) Änderung aktualisieren!
PRG_Stand="22.07.2015"
PRG_Version="1.09"
# Ew

	STD='\033[0;0;39m'
	RED='\033[0;31m'
	GREEN='\033[0;32m'
	YELLOW='\033[1;33m'
	NC='\033[0m' # No Color
	COUNT_LOCALBOOT=0
	COUNT_NETBOOT=0
	COUNT_REPOSITORY=0
	FILESIZE_REPOSITORY=0
	FILESIZE_REP_IN_USE=0
	FILESIZE_REP_MIGRATE=0
	FILESIZE_DEPOT=0
	COUNT_REP_DEP=0
	COUNT_DEP_REP=0
	COUNT_REP_IN_USE=0
	COUNT_REP_MIGRATE=0
	MOUNT_PATH="//10.1.1.2/pgm\$/opsibackup"
	MOUNT_DOMAIN="musterschule.schule.paedml"
	MOUNT_USER="pgmadmin"
	MOUNT_PASSWORD="paedML 3.0"
	MOUNT_LOCAL="/mnt"
	BACKUP_FILE=$MOUNT_LOCAL"/opsi_backup.tar.bz2"
	BACKUP_CONFIG=$MOUNT_LOCAL"/opsi_backup.config.tar.bz2"
	BACKUP_REPOSITORY=$MOUNT_LOCAL"/opsi_backup.repository.tar.bz2"
	BACKUP_DEPOT=$MOUNT_LOCAL"/opsi_backup.depot.tar.bz2"

#Initialisierung - ANFANG -
# Temporäres Verzeichnis anlegen und Dateinamen anpassen
	MeinTEMPDIR=$(mktemp -dt "$0.XXXXXXXXXX") 			# lege temporäres Verzeichnis an
	filename1=$MeinTEMPDIR"/work.dump"				# Arbeitsfile
	filename2=$MeinTEMPDIR"/local_depot_all.files"     	 	# Alle Dateien .opsi, .opsi.md5, .opsi.zsync
	filename3=$MeinTEMPDIR"/local_depot.files"          		# Nur .opsi-Dateien
	filename4=$MeinTEMPDIR"/local_repository_all.files" 		# Alle Dateien .opsi, .opsi.md5, .opsi.zsync
	filename5=$MeinTEMPDIR"/local_repository.files"     		# Nur .opsi-Dateien
	filename6=$MeinTEMPDIR"/rep-dep.files"     	  		# Nur .opsi-Dateien
	filename7=$MeinTEMPDIR"/dep-rep.files"     	  		# Nur .opsi-Dateien
	filename8=$MeinTEMPDIR"/local_repository_in_use.files"    	# Nur .opsi-Dateien
	filename9=$MeinTEMPDIR"/local_repository_migrate.files"   	# Nur .opsi-Dateien
	filename10=$MeinTEMPDIR"/local_repository_migrate_all.files"  	# Nur .opsi-Dateien
#Initialisierung - ENDE -

# Hintergrundfunktionen

Work_Platzbedarf_ermitteln ()
{
	COUNT_LOCALBOOT=0
	COUNT_NETBOOT=0
	COUNT_REPOSITORY=0
	FILESIZE_REPOSITORY=0
	FILESIZE_REP_IN_USE=0
	FILESIZE_REP_MIGRATE=0
	FILESIZE_DEPOT=0
	COUNT_REP_DEP=0
	COUNT_DEP_REP=0
	COUNT_REP_IN_USE=0
	COUNT_REP_MIGRATE=0
	printf "Ermittle opsi-Produkte im Depot... "
	opsi-admin -d method productOnDepot_getIdents > "$filename1"
	if [ $? -eq 0 ]
	then
		printf "${GREEN}ok.${NC}\n"
	else
		printf "${RED}Fehler.${NC}\n"
		Exit 1
	fi
	printf "Analysiere opsi-Produkte im Depot... "
	echo "" > $filename2 # Datei leeren
	echo "" > $filename3 # Datei leeren
	# Liste aus Depot erstellen
	while read -r line
	do
	zeile=$line
    	# Servernamen entfernen
    	input_string=$zeile
    	finde_string=";opsi01.musterschule.schule.paedml"
    	ersetze_string=""
    	output_string="${input_string/$finde_string/$ersetze_string}"
    	# NetbootProdukt ersetzen
    	input_string=$output_string
    	finde_string=";NetbootProduct;"
    	if [[ $input_string == *$finde_string* ]]
    	then
    	    	((COUNT_NETBOOT++))
    	fi
    	# LocalbootProdukt ersetzen
    	input_string=$output_string
    	finde_string=";LocalbootProduct;"
    	if [[ $input_string == *$finde_string* ]]
    	then
    	    	((COUNT_LOCALBOOT++))
    	fi
    	done < "$filename1"
	FILESIZE_DEPOT=$(du --total -m "/var/lib/opsi/depot" | grep 'insgesamt' | cut -f 1)
	printf "${GREEN}ok.${NC}\n"

	printf "Ermittle opsi-Produkte im Repository... "
	ls /var/lib/opsi/repository > "$filename1"

	# Liste aus Depot erstellen
	echo "" > $filename4 # Datei leeren
	echo "" > $filename5 # Datei leeren
	while read -r line
	do
	zeile=$line
    	# .opsi.md5 entfernen
    	input_string=$zeile
    	if [[ $input_string == *".opsi.md5"* ]]
    	then
   	    	echo "$output_string" >> $filename4
    	    	output_string=" "
    	else
    	    	output_string=$input_string
    	fi
    	# .opsi.zsync entfernen
    	input_string=$output_string
    	if [[ $input_string == *".opsi.zsync"* ]]
    	then
    	    	echo "$output_string" >> $filename4
    	    	output_string=" "
    	else
    	    	output_string=$input_string
    	fi
    	# Nur .opsi erfassen
    	input_string=$output_string
    	if [[ $input_string == *".opsi"* ]]
    	then
    	    	echo "$output_string" >> $filename4
    	    	output_string=$input_string
    	    	((COUNT_REPOSITORY++))
    	else
    	    	output_string=" "
    	    	actualsize=0
	fi
    	done < "$filename1"

	printf "${GREEN}ok.${NC}\n"
	printf "Analysiere opsi-Produkte im Repository... "
	FILESIZE_REPOSITORY=$(du --total -m "/var/lib/opsi/repository" | grep 'insgesamt' | cut -f 1)
	printf "${GREEN}ok.${NC}\n"
}

Work_Backup_durchfuehren ()
{
	printf "\n${YELLOW}Backup Teil 1/3: Backup des Backends...${NC}\n\n" 
	sudo opsi-backup -v create "$BACKUP_FILE"
	printf "\n${YELLOW}Backup Teil 2/3: Backup des DEPOTS...${NC}\n\n" 
	cd /
	tar -cf "$BACKUP_DEPOT" var/lib/opsi/depot --checkpoint=10240 --checkpoint-action=dot	
	printf "\n${YELLOW}Backup Teil 3/3: Backup des REPOSITORIES...${NC}\n\n"                      
	cd /
	tar -cf "$BACKUP_REPOSITORY" var/lib/opsi/repository --checkpoint=10240 --checkpoint-action=dot
	echo
}

Work_Restore_durchfuehren ()
{
	printf "\n${YELLOW}Restore Teil 1/4: Restore des REPOSITORIES...${NC}\n\n" 
	cd /
	tar -xf "$BACKUP_REPOSITORY" var/lib/opsi/repository --checkpoint=10240 --checkpoint-action=dot	
	printf "\n${YELLOW}Restore Teil 2/4: Restore des DEPOTS...${NC}\n\n" 
	cd /
	tar -xf "$BACKUP_DEPOT" var/lib/opsi/depot --checkpoint=10240 --checkpoint-action=dot
	printf "\n${YELLOW}Restore Teil 3/4: Restore des Backends...${NC}\n\n"                      
	opsi-backup -v restore "$BACKUP_FILE" --configuration --backends=auto --force
	printf "\n${YELLOW}Restore Teil 4/4: Rechte setzen...${NC}\n\n"                      
	sudo opsi-set-rights
	echo
}

# Menufunktionen

pause(){
	read -p "Fortfahren mit [Eingabe]..." EnterKey
}
 
Zeige_Hauptmenue() {
	clear
	echo "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"	
	echo "   opsi-Backup-and-Restore                                       Version $PRG_Version"
	echo "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
	echo
	echo "1. Backup  (Datensicherung    - alter Server)"
	echo "2. Restore (Wiederherstellung - neuer Server)"
	echo "3. Beenden"
	echo
}
Eingabe_Hauptmenue(){
	local choice
	read -p "Bitte wählen Sie [1 - 3] " choice
	case $choice in
		1) Main_Backupmenue ;;
		2) Main_Restoremenue ;;
		3)  rm -rf $MeinTEMPDIR; exit 0;;
		*) echo -e "${RED}Falsche Eingabe.${STD}" && sleep 2
	esac
}
Zeige_Backupmenue(){
	clear
	echo "~~~~~~~~~~~~~"	
	echo "   Backup"
	echo "~~~~~~~~~~~~~"
	echo
	echo "1. Platzbedarf ermitteln"
	echo "2. Freigabe mounten"
	echo "3. Backup durchführen"
	echo "4. Freigabe unmounten"
	echo "5. Beenden"
	echo
}
Eingabe_Backupmenue(){
	local choice
	read -p "Bitte wählen Sie [1 - 5] " choice
	case $choice in
		1) Platzbedarf_ermitteln ;;
		2) Freigabe_mounten ;;
		3) Backup_durchfuehren ;;
		4) Freigabe_unmounten ;;
		5) rm -rf $MeinTEMPDIR; exit 0;;
		*) echo -e "${RED}Falsche Eingabe.${STD}" && sleep 2
	esac
}

Main_Backupmenue()
{
while true
do
	Zeige_Backupmenue
	Eingabe_Backupmenue
done
}

Zeige_Restoremenue(){
	clear
	echo "~~~~~~~~~~~~~~"	
	echo "   Restore"
	echo "~~~~~~~~~~~~~~"
	echo
	echo "1. Freigabe mounten"
	echo "2. Restore durchführen"
	echo "3. Freigabe unmounten"
	echo "4. Beenden"
	echo
}

Eingabe_Restoremenue() {
	local choice
	read -p "Bitte wählen Sie [1 - 4] " choice
	case $choice in
		1) Freigabe_mounten ;;
		2) Restore_durchfuehren ;;
		3) Freigabe_unmounten ;;
		4) rm -rf $MeinTEMPDIR; exit 0;;
		*) echo -e "${RED}Falsche Eingabe.${STD}" && sleep 2
	esac
}


Main_Restoremenue ()
{
while true
do
	Zeige_Restoremenue
	Eingabe_Restoremenue
done
}

Platzbedarf_ermitteln ()
{
	clear
	echo "~~~~~~~~~~~~~~~~~~~~~~~~~~~~"	
	echo "   Platzbedarf ermitteln"
	echo "~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
	echo
	
	Work_Platzbedarf_ermitteln
	
	printf "\nIm Depot liegen        %4s Netbootprodukte und\n" "$COUNT_NETBOOT"
	printf "                       %4s Localbootprodukte.\n"  "$COUNT_LOCALBOOT"
	printf "  Dateigroesse  ${YELLOW}%11s MB${NC}\n\n" "$FILESIZE_DEPOT"
	printf "Im Repository liegen   %4s Pakete.\n" "$COUNT_REPOSITORY" 
	printf "  Dateigroesse  ${YELLOW}%11s MB${NC}\n\n" "$FILESIZE_REPOSITORY"
	
	pause
}
Freigabe_mounten ()
{

	clear
	echo "~~~~~~~~~~~~~~~~~~~~~~~~"	
	echo "   Freigabe mounten"
	echo "~~~~~~~~~~~~~~~~~~~~~~~~"
	echo
	
	mountpoint $MOUNT_LOCAL > /dev/null
	if [ $? -eq 0 ] ; then
		 echo "Das Netzlaufwerk wurde bereits verbunden!"
		 echo
	else
		 read -p "Freigabepfad eingeben:  " -e -i "$MOUNT_PATH" MOUNT_PATH
		 #read -p "Domäne eingeben:        " -e -i "$MOUNT_DOMAIN" MOUNT_DOMAIN
		 read -p "Benutzernamen eingeben: " -e -i "$MOUNT_USER" MOUNT_USER
		 read -p "Kennwort eingeben:      " -e -i "$MOUNT_PASSWORD" MOUNT_PASSWORD
		 echo
		 echo "Die Freigabe wird nun verbunden..."
		 echo
		 #if [ "$MOUNT_DOMAIN" == "" ]; then
		 	 # Freigabe außerhalb der Domäne
		 	 sudo mount -t cifs "$MOUNT_PATH" /mnt -o user="$MOUNT_USER",password="$MOUNT_PASSWORD"
		 #else
		 	 # Freigabe in der Domäne
		 #	 sudo mount -t cifs "$MOUNT_PATH" /mnt -o user="$MOUNT_USER",domain="$MOUNT_DOMAIN",password="$MOUNT_PASSWORD"
		 #fi
	fi

	pause
}
Freigabe_unmounten ()
{
	clear
	echo "~~~~~~~~~~~~~~~~~~~~~~~~~~"	
	echo "   Freigabe unmounten"
	echo "~~~~~~~~~~~~~~~~~~~~~~~~~~"
	echo
	
	mountpoint $MOUNT_LOCAL > /dev/null
	if [ $? -eq 0 ] ; then
		 echo "Das Netzlaufwerk wird getrennt..."
		 sudo umount "$MOUNT_PATH"
		 echo
	else
		 echo "Das Netzlaufwerk ist nicht (mehr) verbunden!"
		 echo
	fi

	pause

}
Backup_durchfuehren ()
{

	clear
	echo "~~~~~~~~~~~~~~~~~~~~~~~~~"	
	echo "   Backup durchführen"
	echo "~~~~~~~~~~~~~~~~~~~~~~~~~"
	echo
	
	mountpoint $MOUNT_LOCAL > /dev/null
	if [ $? -eq 0 ] ; then
		read -r -p "${1:-Möchten Sie jetzt ein Backup ausführen? [Ja/Nein]} " response
		case $response in
			[jJ][aA]) Work_Backup_durchfuehren ;;
			[jJ])     Work_Backup_durchfuehren ;;
			*)        echo; echo "Nein."; echo ;;
		esac
	else
		 echo "Das Netzlaufwerk ist nicht (mehr) verbunden!"
		 echo
	fi

	pause	
}
Restore_durchfuehren ()
{
	clear
	echo "~~~~~~~~~~~~~~~~~~~~~~~~~~"	
	echo "   Restore durchführen"
	echo "~~~~~~~~~~~~~~~~~~~~~~~~~~"
	echo

	mountpoint $MOUNT_LOCAL > /dev/null
	if [ $? -eq 0 ] ; then
		read -r -p "${1:-Möchten Sie jetzt die Wiederherstellung ausführen? [Ja/Nein]} " response
		case $response in
			[jJ][aA]) Work_Restore_durchfuehren ;;
			[jJ])     Work_Restore_durchfuehren ;;
			*)        echo; echo "Nein."; echo ;;
		esac
	else
		 echo "Das Netzlaufwerk ist nicht (mehr) verbunden!"
		 echo
	fi

	pause	
}
#trap '' SIGINT SIGQUIT SIGTSTP
 
# Main
while true
do
	Zeige_Hauptmenue
	Eingabe_Hauptmenue
done
