/*
 * Decompiled with CFR 0.152.
 */
package com.logpresso.scanner;

import com.logpresso.scanner.DummyInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Log4j2Scanner {
    private static final String BANNER = "Logpresso CVE-2021-44228 Vulnerability Scanner 1.5.0 (2021-12-15)";
    private static final String POTENTIALLY_VULNERABLE = "N/A - potentially vulnerable";
    private static final String JNDI_LOOKUP_CLASS_PATH = "org/apache/logging/log4j/core/lookup/JndiLookup.class";
    private static final String LOG4j_CORE_POM_PROPS = "META-INF/maven/org.apache.logging.log4j/log4j-core/pom.properties";
    private static final boolean isWindows = File.separatorChar == '\\';
    private long scanStartTime = 0L;
    private long lastStatusLoggingTime = System.currentTimeMillis();
    private long lastStatusLoggingCount = 0L;
    private File lastVisitDirectory = null;
    private long scanDirCount = 0L;
    private long scanFileCount = 0L;
    private int vulnerableFileCount = 0;
    private int mitigatedFileCount = 0;
    private int fixedFileCount = 0;
    private int potentiallyVulnerableFileCount = 0;
    private Set<File> vulnerableFiles = new LinkedHashSet<File>();
    private String targetPath;
    private boolean debug = false;
    private boolean trace = false;
    private boolean silent = false;
    private boolean fix = false;
    private boolean force = false;
    private boolean scanZip = false;
    private boolean noSymlink = false;
    private boolean allDrives = false;
    private Set<File> driveLetters = new TreeSet<File>();
    private List<String> excludePaths = new ArrayList<String>();

    public static void main(String[] args) {
        try {
            Log4j2Scanner scanner = new Log4j2Scanner();
            scanner.run(args);
            System.exit(scanner.vulnerableFileCount + scanner.potentiallyVulnerableFileCount);
        }
        catch (Throwable t) {
            System.out.println("Error: " + t.getMessage());
            System.exit(-1);
        }
    }

    public void run(String[] args) throws IOException {
        if (args.length < 1) {
            this.pringUsage();
            return;
        }
        this.parseArguments(args);
        if (this.fix && !this.force) {
            try {
                System.out.print("This command will remove JndiLookup.class from log4j2-core binaries. Are you sure [y/N]? ");
                BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
                String answer = br.readLine();
                if (!answer.equalsIgnoreCase("y")) {
                    System.out.println("interrupted");
                    return;
                }
            }
            catch (Throwable t) {
                System.out.println("error: " + t.getMessage());
                return;
            }
        }
        this.run();
    }

    private void pringUsage() {
        System.out.println(BANNER);
        System.out.println("Usage: log4j2-scan [--fix] target_path");
        System.out.println("");
        System.out.println("--fix");
        System.out.println("\tBackup original file and remove JndiLookup.class from JAR recursively.");
        System.out.println("--force-fix");
        System.out.println("\tDo not prompt confirmation. Don't use this option unless you know what you are doing.");
        System.out.println("--debug");
        System.out.println("\tPrint exception stacktrace for debugging.");
        System.out.println("--trace");
        System.out.println("\tPrint all directories and files while scanning.");
        System.out.println("--silent");
        System.out.println("\tDo not print anything until scan is completed.");
        System.out.println("--scan-zip");
        System.out.println("\tScan also .zip extension files. This option may slow down scanning.");
        System.out.println("--no-symlink");
        System.out.println("\tDo not detect symlink as vulnerable file.");
        System.out.println("--exclude [path_prefix]");
        System.out.println("\tExclude specified paths. You can specify multiple --exclude [path_prefix] pairs");
        System.out.println("--exclude-config [file_path]");
        System.out.println("\tSpecify exclude path list in text file. Paths should be separated by new line. Prepend # for comment.");
        System.out.println("--all-drives");
        System.out.println("\tScan all drives on Windows");
        System.out.println("--drives c,d");
        System.out.println("\tScan specified drives on Windows. Spaces are not allowed here.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseArguments(String[] args) throws IOException {
        int i = 0;
        while (i < args.length) {
            String path;
            if (args[i].equals("--fix")) {
                this.fix = true;
            } else if (args[i].equals("--force-fix")) {
                this.fix = true;
                this.force = true;
            } else if (args[i].equals("--debug")) {
                this.debug = true;
            } else if (args[i].equals("--trace")) {
                this.trace = true;
            } else if (args[i].equals("--silent")) {
                this.silent = true;
            } else if (args[i].equals("--scan-zip")) {
                this.scanZip = true;
            } else if (args[i].equals("--no-symlink")) {
                this.noSymlink = true;
            } else if (args[i].equals("--all-drives")) {
                if (!isWindows) {
                    throw new IllegalArgumentException("--all-drives is supported on Windows only.");
                }
                this.allDrives = true;
            } else if (args[i].equals("--drives")) {
                if (!isWindows) {
                    throw new IllegalArgumentException("--drives is supported on Windows only.");
                }
                if (args.length <= i + 1) throw new IllegalArgumentException("Specify drive letters.");
                String[] stringArray = args[i + 1].split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String letter = stringArray[n2];
                    if ((letter = letter.trim().toUpperCase()).length() != 0) {
                        if (letter.length() > 1) {
                            throw new IllegalArgumentException("Invalid drive letter: " + letter);
                        }
                        char c = letter.charAt(0);
                        if (c < 'A' || c > 'Z') {
                            throw new IllegalArgumentException("Invalid drive letter: " + letter);
                        }
                        this.driveLetters.add(new File(String.valueOf(letter) + ":\\"));
                    }
                    ++n2;
                }
                ++i;
            } else if (args[i].equals("--exclude")) {
                if (args.length <= i + 1) throw new IllegalArgumentException("Specify exclude file path.");
                path = args[i + 1];
                if (path.startsWith("--")) {
                    throw new IllegalArgumentException("Path should not starts with `--`. Specify exclude file path.");
                }
                if (isWindows) {
                    path = path.toUpperCase();
                }
                this.excludePaths.add(path);
                ++i;
            } else if (args[i].equals("--exclude-config")) {
                if (args.length <= i + 1) throw new IllegalArgumentException("Specify exclude file path.");
                path = args[i + 1];
                if (path.startsWith("--")) {
                    throw new IllegalArgumentException("Path should not starts with `--`. Specify exclude file path.");
                }
                File f = new File(path);
                if (!f.exists() || !f.canRead()) {
                    throw new IllegalArgumentException("Cannot read exclude config file: " + f.getAbsolutePath());
                }
                this.loadExcludePaths(f);
                ++i;
            } else {
                if (i != args.length - 1) throw new IllegalArgumentException("unsupported option: " + args[i]);
                this.targetPath = args[i];
            }
            ++i;
        }
        this.verifyDriveLetters();
        if (this.allDrives && !this.driveLetters.isEmpty()) {
            throw new IllegalArgumentException("Cannot specify both --all-drives and --drives options.");
        }
        if (this.allDrives || !this.driveLetters.isEmpty() || this.targetPath != null) return;
        throw new IllegalArgumentException("Specify scan target path.");
    }

    private void loadExcludePaths(File f) throws IOException {
        Closeable fis = null;
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "utf-8"));
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).startsWith("#")) continue;
                if (isWindows) {
                    line = line.toUpperCase();
                }
                this.excludePaths.add(line);
            }
        }
        catch (Throwable throwable) {
            this.ensureClose(fis);
            this.ensureClose(br);
            throw throwable;
        }
        this.ensureClose(fis);
        this.ensureClose(br);
    }

    private void verifyDriveLetters() {
        File[] roots = File.listRoots();
        HashSet<File> availableRoots = new HashSet<File>();
        if (roots != null) {
            File[] fileArray = roots;
            int n = roots.length;
            int n2 = 0;
            while (n2 < n) {
                File root = fileArray[n2];
                availableRoots.add(root);
                ++n2;
            }
        }
        for (File letter : this.driveLetters) {
            if (availableRoots.contains(letter)) continue;
            throw new IllegalStateException("Unknown drive: " + letter);
        }
    }

    public void run() {
        this.scanStartTime = System.currentTimeMillis();
        System.out.println(BANNER);
        try {
            if (this.allDrives) {
                File drive;
                int i = 0;
                System.out.print("Scanning drives: ");
                File[] fileArray = File.listRoots();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    drive = fileArray[n2];
                    if (i++ != 0) {
                        System.out.print(",");
                    }
                    System.out.print(drive);
                    ++n2;
                }
                System.out.println("");
                fileArray = File.listRoots();
                n = fileArray.length;
                n2 = 0;
                while (n2 < n) {
                    drive = fileArray[n2];
                    this.traverse(drive);
                    ++n2;
                }
            } else if (!this.driveLetters.isEmpty()) {
                for (File drive : this.driveLetters) {
                    this.traverse(drive);
                }
            } else {
                File f = new File(this.targetPath);
                System.out.println("Scanning directory: " + f.getAbsolutePath());
                this.traverse(f);
            }
            if (this.fix) {
                this.fix(this.trace);
            }
        }
        catch (Throwable throwable) {
            long elapsed = System.currentTimeMillis() - this.scanStartTime;
            System.out.println();
            System.out.println("Scanned " + this.scanDirCount + " directories and " + this.scanFileCount + " files");
            System.out.println("Found " + this.vulnerableFileCount + " vulnerable files");
            System.out.println("Found " + this.potentiallyVulnerableFileCount + " potentially vulnerable files");
            System.out.println("Found " + this.mitigatedFileCount + " mitigated files");
            if (this.fix) {
                System.out.println("Fixed " + this.fixedFileCount + " vulnerable files");
            }
            System.out.printf("Completed in %.2f seconds\n", (double)elapsed / 1000.0);
            throw throwable;
        }
        long elapsed = System.currentTimeMillis() - this.scanStartTime;
        System.out.println();
        System.out.println("Scanned " + this.scanDirCount + " directories and " + this.scanFileCount + " files");
        System.out.println("Found " + this.vulnerableFileCount + " vulnerable files");
        System.out.println("Found " + this.potentiallyVulnerableFileCount + " potentially vulnerable files");
        System.out.println("Found " + this.mitigatedFileCount + " mitigated files");
        if (this.fix) {
            System.out.println("Fixed " + this.fixedFileCount + " vulnerable files");
        }
        System.out.printf("Completed in %.2f seconds\n", (double)elapsed / 1000.0);
    }

    private void fix(boolean trace) {
        if (!this.vulnerableFiles.isEmpty()) {
            System.out.println("");
        }
        for (File f : this.vulnerableFiles) {
            File backupFile;
            File symlinkFile = null;
            String symlinkMsg = "";
            if (this.isSymlink(f)) {
                try {
                    symlinkFile = f;
                    f = symlinkFile.getCanonicalFile();
                    symlinkMsg = " (from symlink " + symlinkFile.getAbsolutePath() + ")";
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (trace) {
                System.out.printf("Patching %s%s%n", f.getAbsolutePath(), symlinkMsg);
            }
            if ((backupFile = new File(String.valueOf(f.getAbsolutePath()) + ".bak")).exists()) {
                System.out.println("Error: Cannot create backup file. .bak File already exists. Skipping " + f.getAbsolutePath());
                continue;
            }
            if (!this.copyAsIs(f, backupFile)) continue;
            if (!this.truncate(f)) {
                System.out.println("Error: Cannot patch locked file " + f.getAbsolutePath());
                continue;
            }
            if (this.copyExceptJndiLookup(backupFile, f)) {
                ++this.fixedFileCount;
                System.out.printf("Fixed: %s%s%n", f.getAbsolutePath(), symlinkMsg);
                continue;
            }
            this.copyAsIs(backupFile, f);
        }
    }

    /*
     * Loose catch block
     */
    private boolean truncate(File f) {
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(f, "rw");
            raf.setLength(0L);
            this.ensureClose(raf);
            return true;
        }
        catch (Throwable t) {
            this.ensureClose(raf);
            return false;
            catch (Throwable throwable) {
                this.ensureClose(raf);
                throw throwable;
            }
        }
    }

    private boolean copyAsIs(File srcFile, File dstFile) {
        FileInputStream is = null;
        FileOutputStream os = null;
        try {
            int len;
            is = new FileInputStream(srcFile);
            os = new FileOutputStream(dstFile);
            byte[] buf = new byte[32768];
            while ((len = is.read(buf)) >= 0) {
                os.write(buf, 0, len);
            }
            this.ensureClose(is);
            this.ensureClose(os);
            return true;
        }
        catch (Throwable t) {
            try {
                System.out.println("Error: Cannot copy file " + srcFile.getAbsolutePath() + " - " + t.getMessage());
                this.ensureClose(is);
                this.ensureClose(os);
                return false;
            }
            catch (Throwable throwable) {
                this.ensureClose(is);
                this.ensureClose(os);
                throw throwable;
            }
        }
    }

    private boolean copyExceptJndiLookup(File srcFile, File dstFile) {
        ZipFile srcZipFile = null;
        ZipOutputStream zos = null;
        try {
            srcZipFile = new ZipFile(srcFile);
            zos = new ZipOutputStream(new FileOutputStream(dstFile));
            zos.setMethod(0);
            zos.setLevel(0);
            Enumeration<? extends ZipEntry> e = srcZipFile.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                if (entry.getName().equals(JNDI_LOOKUP_CLASS_PATH)) continue;
                if (entry.isDirectory()) {
                    ZipEntry newEntry = new ZipEntry(entry.getName());
                    newEntry.setMethod(0);
                    newEntry.setCompressedSize(0L);
                    newEntry.setSize(0L);
                    newEntry.setCrc(0L);
                    zos.putNextEntry(newEntry);
                    continue;
                }
                this.copyZipEntry(srcZipFile, entry, zos);
            }
            this.ensureClose(srcZipFile);
            this.ensureClose(zos);
            return true;
        }
        catch (Throwable t) {
            try {
                if (this.debug) {
                    t.printStackTrace();
                }
                System.out.println("Error: Cannot fix file (" + t.getMessage() + "). rollback original file " + dstFile.getAbsolutePath());
                this.ensureClose(srcZipFile);
                this.ensureClose(zos);
                return false;
            }
            catch (Throwable throwable) {
                this.ensureClose(srcZipFile);
                this.ensureClose(zos);
                throw throwable;
            }
        }
    }

    private void copyZipEntry(ZipFile srcZipFile, ZipEntry zipEntry, ZipOutputStream zos) throws IOException {
        InputStream is = null;
        try {
            is = srcZipFile.getInputStream(zipEntry);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            if (this.isScanTarget(zipEntry.getName())) {
                this.copyNestedJar(is, bos);
            } else {
                int len;
                byte[] buf = new byte[32768];
                while ((len = is.read(buf)) >= 0) {
                    bos.write(buf, 0, len);
                }
            }
            byte[] tempBuf = bos.toByteArray();
            ZipEntry entry = new ZipEntry(zipEntry.getName());
            entry.setMethod(0);
            entry.setCompressedSize(tempBuf.length);
            entry.setSize(tempBuf.length);
            entry.setCrc(this.computeCrc32(tempBuf));
            zos.putNextEntry(entry);
            this.transfer(new ByteArrayInputStream(tempBuf), zos);
        }
        finally {
            this.ensureClose(is);
        }
    }

    private void transfer(InputStream is, OutputStream os) throws IOException {
        int len;
        byte[] buf = new byte[32768];
        while ((len = is.read(buf)) >= 0) {
            os.write(buf, 0, len);
        }
    }

    private void copyNestedJar(InputStream is, OutputStream os) throws IOException {
        ZipInputStream zis = null;
        ZipOutputStream zos = null;
        try {
            ZipEntry zipEntry;
            zis = new ZipInputStream(new DummyInputStream(is));
            zos = new ZipOutputStream(os);
            while ((zipEntry = zis.getNextEntry()) != null) {
                if (zipEntry.getName().equals(JNDI_LOOKUP_CLASS_PATH)) continue;
                if (zipEntry.isDirectory()) {
                    ZipEntry entry = new ZipEntry(zipEntry.getName());
                    zos.putNextEntry(entry);
                    continue;
                }
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                if (this.isScanTarget(zipEntry.getName())) {
                    this.copyNestedJar(zis, bos);
                } else {
                    int len;
                    byte[] buf = new byte[32768];
                    while ((len = zis.read(buf)) >= 0) {
                        bos.write(buf, 0, len);
                    }
                }
                byte[] outputBuf = bos.toByteArray();
                ZipEntry entry = new ZipEntry(zipEntry.getName());
                zos.putNextEntry(entry);
                this.transfer(new ByteArrayInputStream(outputBuf), zos);
            }
        }
        catch (Throwable throwable) {
            this.ensureClose(zis);
            if (zos != null) {
                zos.finish();
            }
            throw throwable;
        }
        this.ensureClose(zis);
        if (zos != null) {
            zos.finish();
        }
    }

    private long computeCrc32(byte[] buf) {
        CRC32 crc = new CRC32();
        crc.update(buf, 0, buf.length);
        return crc.getValue();
    }

    private void traverse(File f) {
        if (!this.silent && this.canStatusReporting()) {
            this.printScanStatus();
        }
        String path = f.getAbsolutePath();
        if (f.isDirectory()) {
            this.lastVisitDirectory = f;
            if (this.isExcluded(path)) {
                if (this.trace) {
                    System.out.println("Skipping excluded directory: " + path);
                }
                return;
            }
            if (this.isSymlink(f)) {
                if (this.trace) {
                    System.out.println("Skipping symlink: " + path);
                }
                return;
            }
            if (this.isExcludedDirectory(path)) {
                if (this.trace) {
                    System.out.println("Skipping directory: " + path);
                }
                return;
            }
            if (this.trace) {
                System.out.println("Scanning directory: " + path);
            }
            ++this.scanDirCount;
            File[] files = f.listFiles();
            if (files == null) {
                return;
            }
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                this.traverse(file);
                ++n2;
            }
        } else {
            ++this.scanFileCount;
            if (this.noSymlink && this.isSymlink(f)) {
                if (this.trace) {
                    System.out.println("Skipping symlink: " + path);
                }
            } else if (this.isScanTarget(path)) {
                if (this.trace) {
                    System.out.println("Scanning file: " + path);
                }
                this.scanJarFile(f, this.fix);
            } else if (this.trace) {
                System.out.println("Skipping file: " + path);
            }
        }
    }

    private void printScanStatus() {
        long now = System.currentTimeMillis();
        int elapsed = (int)((now - this.scanStartTime) / 1000L);
        System.out.printf("Running scan (%ds): scanned %d directories, %d files, last visit: %s%n", elapsed, this.scanDirCount, this.scanFileCount, this.lastVisitDirectory.getAbsolutePath());
        this.lastStatusLoggingCount = this.scanFileCount;
        this.lastStatusLoggingTime = System.currentTimeMillis();
    }

    private boolean canStatusReporting() {
        return this.scanFileCount - this.lastStatusLoggingCount >= 1000L && System.currentTimeMillis() - this.lastStatusLoggingTime >= 10000L;
    }

    private boolean isSymlink(File f) {
        try {
            String canonicalPath = f.getCanonicalPath();
            String absolutePath = f.getAbsolutePath();
            if (isWindows) {
                canonicalPath = canonicalPath.toUpperCase();
                absolutePath = absolutePath.toUpperCase();
            }
            return !canonicalPath.contains(absolutePath);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private boolean isExcludedDirectory(String path) {
        if (isWindows && path.toUpperCase().indexOf("$RECYCLE.BIN") == 3) {
            return true;
        }
        return path.equals("/proc") || path.startsWith("/proc/") || path.equals("/sys") || path.startsWith("/sys/") || path.equals("/dev") || path.startsWith("/dev/") || path.equals("/run") || path.startsWith("/run/") || path.equals("/var/run") || path.startsWith("/var/run/");
    }

    /*
     * Loose catch block
     */
    private void scanJarFile(File jarFile, boolean fix) {
        block20: {
            ZipFile zipFile = null;
            Closeable is = null;
            boolean vulnerable = false;
            boolean mitigated = false;
            boolean potentiallyVulnerable = false;
            try {
                try {
                    zipFile = new ZipFile(jarFile);
                    Status status = this.checkLog4jVersion(jarFile, fix, zipFile);
                    vulnerable = status == Status.VULNERABLE;
                    mitigated = status == Status.MITIGATED;
                    potentiallyVulnerable = status == Status.POTENTIALLY_VULNERABLE;
                    Enumeration<? extends ZipEntry> e = zipFile.entries();
                    while (e.hasMoreElements()) {
                        ZipEntry zipEntry = e.nextElement();
                        if (zipEntry.isDirectory() || !this.isScanTarget(zipEntry.getName())) continue;
                        Status nestedJarStatus = this.scanNestedJar(jarFile, zipFile, zipEntry);
                        vulnerable |= nestedJarStatus == Status.VULNERABLE;
                        mitigated |= nestedJarStatus == Status.MITIGATED;
                        potentiallyVulnerable |= nestedJarStatus == Status.POTENTIALLY_VULNERABLE;
                    }
                    if (vulnerable) {
                        ++this.vulnerableFileCount;
                    } else if (mitigated) {
                        ++this.mitigatedFileCount;
                    } else if (potentiallyVulnerable) {
                        ++this.potentiallyVulnerableFileCount;
                    }
                    if (fix && vulnerable) {
                        this.vulnerableFiles.add(jarFile);
                    }
                }
                catch (ZipException e) {
                    System.out.printf("Skipping broken jar file %s ('%s')%n", jarFile, e.getMessage());
                    this.ensureClose(is);
                    this.ensureClose(zipFile);
                }
                catch (IllegalArgumentException e) {
                    if (e.getMessage().equals("MALFORMED")) {
                        System.out.printf("Skipping broken jar file %s ('%s')%n", jarFile, e.getMessage());
                    } else {
                        System.out.printf("Scan error: '%s' on file: %s%n", e.getMessage(), jarFile);
                        if (this.debug) {
                            e.printStackTrace();
                        }
                    }
                    this.ensureClose(is);
                    this.ensureClose(zipFile);
                }
                catch (Throwable t) {
                    System.out.printf("Scan error: '%s' on file: %s%n", t.getMessage(), jarFile);
                    if (this.debug) {
                        t.printStackTrace();
                    }
                    this.ensureClose(is);
                    this.ensureClose(zipFile);
                    break block20;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
            }
            finally {
                this.ensureClose(is);
                this.ensureClose(zipFile);
            }
        }
    }

    private Status checkLog4jVersion(File jarFile, boolean fix, ZipFile zipFile) throws IOException {
        ZipEntry entry = zipFile.getEntry(LOG4j_CORE_POM_PROPS);
        if (entry == null) {
            entry = zipFile.getEntry(JNDI_LOOKUP_CLASS_PATH);
            if (entry != null) {
                String path = jarFile.getAbsolutePath();
                this.printDetection(path, POTENTIALLY_VULNERABLE, false, true);
                return Status.POTENTIALLY_VULNERABLE;
            }
            return Status.NOT_VULNERABLE;
        }
        InputStream is = null;
        try {
            is = zipFile.getInputStream(entry);
            String version = this.loadVulnerableLog4jVersion(is);
            if (version != null) {
                boolean mitigated = zipFile.getEntry(JNDI_LOOKUP_CLASS_PATH) == null;
                String path = jarFile.getAbsolutePath();
                this.printDetection(path, version, mitigated, false);
                Status status = mitigated ? Status.MITIGATED : Status.VULNERABLE;
                return status;
            }
            Status status = Status.NOT_VULNERABLE;
            return status;
        }
        finally {
            this.ensureClose(is);
        }
    }

    private void printDetection(String path, String version, boolean mitigated, boolean potential) {
        String msg = potential ? "[?]" : "[*]";
        String cve = "CVE-2021-44228";
        if (version.startsWith("2.15.")) {
            cve = "CVE-2021-45046";
        }
        msg = String.valueOf(msg) + " Found " + cve + " vulnerability in " + path + ", log4j " + version;
        if (mitigated) {
            msg = String.valueOf(msg) + " (mitigated)";
        }
        System.out.println(msg);
    }

    private Status scanNestedJar(File fatJarFile, ZipFile zipFile, ZipEntry zipEntry) {
        InputStream is = null;
        try {
            Status status;
            is = zipFile.getInputStream(zipEntry);
            ArrayList<String> pathChain = new ArrayList<String>();
            pathChain.add(zipEntry.getName());
            Status status2 = status = this.scanStream(fatJarFile, is, pathChain);
            return status2;
        }
        catch (IOException e) {
            String msg = "cannot scan nested jar " + fatJarFile.getAbsolutePath() + ", entry " + zipEntry.getName();
            throw new IllegalStateException(msg, e);
        }
        finally {
            this.ensureClose(is);
        }
    }

    private Status scanStream(File fatJarFile, InputStream is, List<String> pathChain) {
        ZipInputStream zis = null;
        Status maxNestedJarStatus = Status.NOT_VULNERABLE;
        String vulnerableVersion = null;
        boolean mitigated = true;
        boolean pomFound = false;
        try {
            String path;
            ZipEntry entry;
            zis = new ZipInputStream(new DummyInputStream(is));
            while ((entry = zis.getNextEntry()) != null) {
                if (entry.getName().equals(LOG4j_CORE_POM_PROPS)) {
                    vulnerableVersion = this.loadVulnerableLog4jVersion(zis);
                    pomFound = true;
                }
                if (entry.getName().equals(JNDI_LOOKUP_CLASS_PATH)) {
                    mitigated = false;
                }
                if (!this.isScanTarget(entry.getName())) continue;
                pathChain.add(entry.getName());
                Status nestedStatus = this.scanStream(fatJarFile, zis, pathChain);
                if (nestedStatus.ordinal() > maxNestedJarStatus.ordinal()) {
                    maxNestedJarStatus = nestedStatus;
                }
                pathChain.remove(pathChain.size() - 1);
            }
            if (vulnerableVersion != null) {
                path = fatJarFile + " (" + this.toString(pathChain) + ")";
                this.printDetection(path, vulnerableVersion, mitigated, false);
                Status selfStatus = mitigated ? Status.MITIGATED : Status.VULNERABLE;
                return selfStatus.ordinal() > maxNestedJarStatus.ordinal() ? selfStatus : maxNestedJarStatus;
            }
            if (!mitigated && !pomFound) {
                path = fatJarFile + " (" + this.toString(pathChain) + ")";
                this.printDetection(path, POTENTIALLY_VULNERABLE, false, true);
                if (maxNestedJarStatus.ordinal() > Status.POTENTIALLY_VULNERABLE.ordinal()) {
                    return maxNestedJarStatus;
                }
                return Status.POTENTIALLY_VULNERABLE;
            }
            if (maxNestedJarStatus != Status.NOT_VULNERABLE) {
                return maxNestedJarStatus;
            }
            return Status.NOT_VULNERABLE;
        }
        catch (IOException e) {
            String entryName = pathChain.get(pathChain.size() - 1);
            if (entryName.toLowerCase().endsWith(".rar")) {
                return Status.NOT_VULNERABLE;
            }
            String msg = "cannot scan nested jar " + fatJarFile.getAbsolutePath() + ", path " + this.toString(pathChain);
            throw new IllegalStateException(msg, e);
        }
    }

    private String toString(List<String> pathChain) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (String path : pathChain) {
            if (i++ != 0) {
                sb.append(" > ");
            }
            sb.append(path);
        }
        return sb.toString();
    }

    private String loadVulnerableLog4jVersion(InputStream is) throws IOException {
        Properties props = new Properties();
        props.load(is);
        String groupId = props.getProperty("groupId");
        String artifactId = props.getProperty("artifactId");
        String version = props.getProperty("version");
        if (groupId.equals("org.apache.logging.log4j") && artifactId.equals("log4j-core")) {
            String[] tokens = version.split("\\.");
            int major = Integer.parseInt(tokens[0]);
            int minor = Integer.parseInt(tokens[1]);
            int patch = 0;
            if (tokens.length > 2) {
                patch = Integer.parseInt(tokens[2]);
            }
            if (this.isVulnerable(major, minor, patch)) {
                return version;
            }
        }
        return null;
    }

    private boolean isScanTarget(String path) {
        String loweredPath = path.toLowerCase();
        if (this.scanZip && loweredPath.endsWith(".zip")) {
            return true;
        }
        return loweredPath.endsWith(".jar") || loweredPath.endsWith(".war") || loweredPath.endsWith(".ear") || loweredPath.endsWith(".aar") || loweredPath.endsWith(".rar");
    }

    private boolean isExcluded(String path) {
        if (isWindows) {
            path = path.toUpperCase();
        }
        for (String excludePath : this.excludePaths) {
            if (!path.startsWith(excludePath)) continue;
            return true;
        }
        return false;
    }

    private boolean isVulnerable(int major, int minor, int patch) {
        return major == 2 && minor < 16;
    }

    private void ensureClose(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void ensureClose(ZipFile zipFile) {
        if (zipFile != null) {
            try {
                zipFile.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        NOT_VULNERABLE,
        MITIGATED,
        POTENTIALLY_VULNERABLE,
        VULNERABLE;

    }
}

